import os
from groupdocs.conversion import License as ConversionLicense, Converter
from groupdocs.conversion.options.convert import PdfConvertOptions
from groupdocs.metadata import License as MetadataLicense, Metadata

def convert_and_remove_metadata():
    # Get license file absolute path
    license_path = os.path.abspath("./GroupDocs.Total.lic")

    if os.path.exists(license_path):
        # License GroupDocs.Conversion
        conversion_license = ConversionLicense()
        conversion_license.set_license(license_path)

        # License GroupDocs.Metadata
        metadata_license = MetadataLicense()
        metadata_license.set_license(license_path)

    # Load DOCX file
    with Converter("./business-plan.docx") as converter:
        # Create convert options
        pdf_convert_options = PdfConvertOptions()

        # Convert DOCX to PDF
        converter.convert("./business-plan.pdf", pdf_convert_options)

    # Load created PDF file
    with Metadata("./business-plan.pdf") as metadata:
      # Remove the metadata
      metadata.sanitize()
     
      # Save the file with no metadata
      metadata.save("./converted-no-metadata.pdf")

if __name__ == "__main__":
    convert_and_remove_metadata()